/*======================================================================*/
/*		TITLE:			DEBUG.C				*/
/*		Function:		DEBUG routines			*/
/*									*/
/*		First Edit:		02/04/93			*/
/*		Programmer:		Andrew J. Burgess		*/
/*									*/
/*		   COPYRIGHT 1993 ATARI CORPORATION.			*/
/*	  UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,		*/
/*	  PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR		*/
/*	THE ASSOCIATED AUDIOVISUAL WORK	IS STRICTLY PROHIBITED.		*/
/*	       		ALL RIGHTS RESERVED.				*/
/*									*/
/*----------------------------------------------------------------------*/
/*	funcInit()	- initialize Function trace variables		*/
/*	funcEnter()	- tell user you've entered a function.		*/
/*	funcExit()	- tell user you've exited a function.		*/
/*	funcEnd()	- terminate debug and Function trace variables	*/
/*	ErrorMessage()	- output an ERROR message.			*/
/*	WarnMessage()	- output an WARNING message.			*/
/*	DebugMessage()	- output an DEBUGGING message.			*/
/*	Indent()	- prepare indenting for message			*/
/*======================================================================*/

#include <stdio.h>
#include "defs.h"

/*======================================================================*/
FILE	*DFile;
char	FuncIndent;

FILE	*fopen();

STRING		MessageBuffer[384];

/*======================================================================*/
/*	funcInit()	- initialize Function trace variables		*/
/*======================================================================*/

funcInit( )
{
	FuncIndent = 0;
	DFile      = NULL;

#if (STD)
	DFile = stdout;
#else
	if ((DFile=fopen("tmp.dbg","w")) == NULL)
	{
		fprintf( stdout, "\nERROR: file (tmp.dbg) could not be opened\n" );
		fflush( stdout );
		exit( ERROR );
	}
#endif

}

/*======================================================================*/
/*	funcEnter()	- tell user you've entered a function.		*/
/*======================================================================*/

funcEnter( funcname, callfile, linenumber )
	STRING	*funcname;
	STRING	*callfile;
	U16	linenumber;
{
	Indent();

	fprintf( DFile, "%s : Entered from %s at line %d\n",
			funcname, callfile, linenumber );

	fflush( DFile );

	++FuncIndent;
}

/*======================================================================*/
/*	funcExit()	- tell user you've exited a function.		*/
/*======================================================================*/

funcExit( funcname,callfile,linenumber )
	STRING	*funcname;
	STRING	*callfile;
	U16	linenumber;
{
	--FuncIndent;

	Indent();

	fprintf( DFile, "%s : Exited from %s at line %d\n",
			funcname, callfile, linenumber );

	fflush( DFile );
}

/*======================================================================*/
/*	funcEnd()	- terminate debug and Function trace variables	*/
/*======================================================================*/

funcEnd( )
{
	if ( DFile != NULL )
		fclose(DFile);
}

/*======================================================================*/
/*	ErrorMessage()	- output an ERROR message.			*/
/*======================================================================*/

ErrorMessage( message, fileName, lineNumber )
	STRING	*message;
	STRING	*fileName;
	int	lineNumber;
{

#if (STD==0)
	fprintf( DFile,"\nERROR (%s, %d): %s\n", fileName, lineNumber, message );
	fflush( DFile );
#endif
	fprintf( stdout, "\nERROR (%s, %d): %s\n", fileName, lineNumber, message );   
	fflush( stdout );
	exit( ERROR );
}

/*======================================================================*/
/*	WarnMessage()	- output an WARNING message.			*/
/*======================================================================*/

WarnMessage( message, fileName, lineNumber )
	STRING	*message;
	STRING	*fileName;
	int	lineNumber;
{

#if (STD==0)
	fprintf( DFile,"\nWARNING (%s, %d): %s\n", fileName, lineNumber, message );
	fflush( DFile );
#endif
	fprintf( stdout, "\nWARNING (%s, %d): %s\n", fileName, lineNumber, message );   
	fflush( stdout );
}

/*======================================================================*/
/*	DebugMessage()	- output an DEBUGGING message.			*/
/*======================================================================*/

DebugMessage( message, fileName, lineNumber )
	STRING	*message;
	STRING	*fileName;
	int	lineNumber;
{
	Indent();

#if 1
	fprintf( DFile,"%s\t\t%s:%d\n", message, fileName, lineNumber );
#else
	fprintf( DFile,"DEBUG (%s, %d): %s\n", fileName, lineNumber, message );
#endif
	fflush( DFile );
}

/*======================================================================*/
/*	Indent()	- prepare indenting for message			*/
/*======================================================================*/

Indent( )
{

	int		i;

	fprintf( DFile, "\n" );

	for( i=0; i< FuncIndent; i++ )
	{
		fprintf( DFile, "    " );
	}
}

/*======================================================================*/
/*				EOF					*/
/*======================================================================*/

